//+------------------------------------------------------------------+
//|                                      Cost Avg -Common RSI v1.mq4 |
//+------------------------------------------------------------------+
#property copyright "Amritendu Maji"


//----------------------- USER INPUT
extern int MagicNumber = 12411;
extern double LotExponent = 1.666667;
extern double slip = 3;
extern double Lots = 0.1;
extern double TakeProfit = 500;
extern double Stoploss = 500;
extern double PipStep = 25;
extern int MaxTrades = 10;
extern bool UseSafeMode = true;
extern bool UseRSIforAddTrade = true;
extern bool UseStopLoss = false;
extern double TotalEquityRisk = 33; //loss as a percentage of equity

extern double BuyLevel = 20;//10;
extern double SellLevel = 80;//90;
extern double MidLevel = 50;
extern int SlowPeriod = 9;
extern int FastPeriod = 4;
extern int PriceType = 5; 


//----------------------- SETUP VARS
double PriceTarget, StartEquity, Profit, Loss, BuyTarget, SellTarget;
double AveragePrice;
double LastBuyPrice, LastSellPrice, ClosePrice, MinSpread, Spread;
int flag;
string EAName = "CostAvg-ComRSIv1";
datetime timeprev=0, expiration;
int NumOfTrades=0;
double iLots;
int cnt=0, total, totalpendingorders;
double Stopper=0;  
bool TradeNow = false, LongTrade=false, ShortTrade=false;
int TimeFrame = 0;
int Current = 1;
int ticket;
bool buy=false, sell=false;
bool NewOrdersPlaced = false;
bool IsClosed;

int init()
{
  MinSpread = MarketInfo(Symbol(), MODE_STOPLEVEL)*Point;
  Spread = MarketInfo(Symbol(), MODE_SPREAD)*Point;

 return(0);
}

int deinit()
{
 return(0);
}

int start()
{
  
  
 if(timeprev==Time[0])
  return(0);
 timeprev=Time[0];
 
  double CurrentPairProfit = CalculateProfit();
  if(UseStopLoss)
  if(CurrentPairProfit<0 && MathAbs(CurrentPairProfit)>(TotalEquityRisk/100)*AccountEquityHigh())
  {
   CloseThisSymbolAll();
   Print("Closed All due to Stop Out");
  }
    
  double sRSI_C=iRSI(Symbol(),TimeFrame,SlowPeriod,PriceType,Current);
  double sRSI_P=iRSI(Symbol(),TimeFrame,SlowPeriod,PriceType,Current+1);
  double fRSI_C=iRSI(Symbol(),TimeFrame,FastPeriod,PriceType,Current);
  double fRSI_P=iRSI(Symbol(),TimeFrame,FastPeriod,PriceType,Current+1);
  
  
  
  if (UseSafeMode)
  {
   if(sRSI_C>=SellLevel)
//   if(fRSI_C>=SellLevel)
   {
    IsClosed = CloseLongs();
    if(IsClosed) Print("Long Closed due to RSI");  
   }
   
   if(sRSI_C<=BuyLevel)
//   if(fRSI_C<=BuyLevel)
   {
    IsClosed = CloseShorts();
    if(IsClosed) Print("Short Closed due to RSI");  
   }
   
  } //UseSafeMode
  

  total=CountTrades();
  totalpendingorders=CountPendingOrders();
  if (total == 0) flag = 0;
  for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
  {
    OrderSelect(cnt,SELECT_BY_POS,MODE_TRADES);

    if(OrderSymbol()!=Symbol()||OrderMagicNumber()!=MagicNumber)
     continue;
   
    if(OrderSymbol()==Symbol()&&OrderMagicNumber()==MagicNumber)
    if(OrderType()==OP_BUY)
    {
     LongTrade = true;
     ShortTrade = false;
     break;
    }
    if(OrderSymbol()==Symbol()&&OrderMagicNumber()==MagicNumber)
    if(OrderType()==OP_SELL)
    {
     LongTrade = false;
     ShortTrade = true;
     break;
    }
  }
  
  if(UseRSIforAddTrade)
  {
   if(total>0 && total <= MaxTrades)
   {
    RefreshRates();
    LastBuyPrice = FindLastBuyPrice();
    LastSellPrice = FindLastSellPrice();
    if(LongTrade)
//     if(fRSI_C<BuyLevel && fRSI_P>BuyLevel)  
//     if(fRSI_C<BuyLevel && (LastBuyPrice - Ask) >= (PipStep*Point))  
//     if(fRSI_C>BuyLevel && fRSI_P<BuyLevel)  
     if(fRSI_C>BuyLevel && fRSI_P<BuyLevel && (LastBuyPrice - Ask) >= (PipStep*Point))  
     {
      TradeNow = true;
     }
    if(ShortTrade)
//     if(fRSI_C>SellLevel && fRSI_P<SellLevel)  
//     if(fRSI_C>SellLevel && (Bid- LastSellPrice) >= (PipStep*Point))  
//     if(fRSI_C<SellLevel && fRSI_P>SellLevel)  
     if(fRSI_C<SellLevel && fRSI_P>SellLevel && (Bid- LastSellPrice) >= (PipStep*Point))  
     {
      TradeNow = true;
     }
   } 
  }
  else
  {
   if(total>0 && total <= MaxTrades)
   {
    RefreshRates();
    if(LongTrade && (LastBuyPrice - Ask) >= (PipStep*Point))
     {
      TradeNow = true;
     }
    if(ShortTrade && (Bid- LastSellPrice) >= (PipStep*Point))
     {
      TradeNow = true;
     }
   } 
  }
  
  
  if (total < 1)
  {
   ShortTrade = false;
   LongTrade = false;
   TradeNow = true;
   StartEquity = AccountEquity();
  }

  if (TradeNow) 
  {
   if(ShortTrade)
   {
    NumOfTrades = total;
    iLots = NormalizeDouble(Lots*MathPow(LotExponent,NumOfTrades),1);
    RefreshRates();
    ticket = OpenPendingOrder(OP_SELL,iLots,Bid,slip,Ask,0,0,EAName+"-"+NumOfTrades,MagicNumber,0,HotPink);
    if(ticket<0){Print("Error: ",GetLastError()); return(0);}
     LastSellPrice = FindLastSellPrice();
    TradeNow = false;
   }
   else if (LongTrade)
   {   
    NumOfTrades = total;
    iLots = NormalizeDouble(Lots*MathPow(LotExponent,NumOfTrades),1);
    ticket = OpenPendingOrder(OP_BUY,iLots,Ask,slip,Bid,0,0,EAName+"-"+NumOfTrades,MagicNumber,0,Lime);
    if(ticket<0){Print("Error: ",GetLastError()); return(0);}
     LastBuyPrice = FindLastBuyPrice();
    TradeNow = false;
   }
  }
  
  if (TradeNow && totalpendingorders<1) 
  {
   
   if (!ShortTrade && !LongTrade)
   {
    NumOfTrades = total;
    iLots = NormalizeDouble(Lots*MathPow(LotExponent,NumOfTrades),1);
//    if(sRSI_C>SellLevel && sRSI_P<SellLevel)
    if(sRSI_C<SellLevel && sRSI_P>SellLevel)
//    if(sRSI_C<MidLevel && sRSI_P>MidLevel)
    {  
     ticket = OpenPendingOrder(OP_SELL,iLots,Bid,slip,Ask,0,0,EAName+"-"+NumOfTrades,MagicNumber,0,HotPink);
     if(ticket<0){Print("Error: ",GetLastError()); return(0);}
      LastSellPrice = FindLastSellPrice();
    }
//    if(sRSI_C<BuyLevel && sRSI_P>BuyLevel)
    if(sRSI_C>BuyLevel && sRSI_P<BuyLevel)
//    if(sRSI_C>MidLevel && sRSI_P<MidLevel)
    {  
     ticket = OpenPendingOrder(OP_BUY,iLots,Ask,slip,Bid,0,0,EAName+"-"+NumOfTrades,MagicNumber,0,Lime);
     if(ticket<0){Print("Error: ",GetLastError()); return(0);}
      LastBuyPrice = FindLastBuyPrice();
    }

    TradeNow = false;
   }
  }
  
//----------------------- CALCULATE AVERAGE OPENING PRICE
   total=CountTrades();
   AveragePrice=0;
   double Count = 0;
   for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
    OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
    if(OrderSymbol()!=Symbol()||OrderMagicNumber()!=MagicNumber)
     continue;
    if(OrderSymbol()==Symbol()&&OrderMagicNumber()==MagicNumber)
     if(OrderType()==OP_BUY || OrderType()==OP_SELL)  
      {
       AveragePrice=AveragePrice+OrderOpenPrice()*OrderLots();
       Count = Count + OrderLots();
      }
   }
   if(total > 0)
    AveragePrice=NormalizeDouble(AveragePrice/Count, Digits);

   
//----------------------- RECALCULATE STOPLOSS & PROFIT TARGET BASED ON AVERAGE OPENING PRICE

   for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
    OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
    if(OrderSymbol()!=Symbol()||OrderMagicNumber()!=MagicNumber)
     continue;
    if(OrderSymbol()==Symbol()&&OrderMagicNumber()==MagicNumber)
     if(OrderType()==OP_BUY) // Calculate profit/stop target for long 
     {
      PriceTarget=AveragePrice+(TakeProfit*Point);
      BuyTarget = PriceTarget;
      Stopper=AveragePrice-(Stoploss*Point); 
//      Stopper=0; 
      flag = 1;
     }
    if(OrderSymbol()==Symbol()&&OrderMagicNumber()==MagicNumber)
     if(OrderType()==OP_SELL) // Calculate profit/stop target for short
     {
      PriceTarget=AveragePrice-(TakeProfit*Point);
      SellTarget = PriceTarget;
      Stopper=AveragePrice+(Stoploss*Point);  
//      Stopper=0; 
      flag = 1; 
     }
   }
//----------------------- IF NEEDED CHANGE ALL OPEN ORDERS TO NEWLY CALCULATED PROFIT TARGET    
  if(flag==1)// check if average has really changed
  {   
   for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
    {
//     PriceTarget=total;
     OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);            
     if(OrderSymbol()!=Symbol()||OrderMagicNumber()!=MagicNumber)
      continue;
     if(OrderSymbol()==Symbol()&&OrderMagicNumber()==MagicNumber)
      OrderModify(OrderTicket(),0,Stopper,PriceTarget,0,Yellow);// set all positions to averaged levels
    }
  }


} //Start Main

int CountTrades()
{
 int count=0;
 int trade;
 for(trade=OrdersTotal()-1;trade>=0;trade--)
 {
  OrderSelect(trade,SELECT_BY_POS,MODE_TRADES);
  
  if(OrderSymbol()!=Symbol()||OrderMagicNumber()!=MagicNumber)
   continue;
   
  if(OrderSymbol()==Symbol()&&OrderMagicNumber()==MagicNumber)
  if(OrderType()==OP_SELL || OrderType()==OP_BUY)
   count++;
 }//for
 return(count);
}

int CountPendingOrders()
{
 int count=0;
 int trade;
 for(trade=OrdersTotal()-1;trade>=0;trade--)
 {
  OrderSelect(trade,SELECT_BY_POS,MODE_TRADES);
  
  if(OrderSymbol()!=Symbol()||OrderMagicNumber()!=MagicNumber)
   continue;
   
  if(OrderSymbol()==Symbol()&&OrderMagicNumber()==MagicNumber)
  if(OrderType()==OP_SELLLIMIT || OrderType()==OP_BUYLIMIT)
   count++;
 }//for
 return(count);
}


int OpenPendingOrder(int pType,double pLots,double pLevel,int sp, double pr, int sl, int tp,string pComment,int pMagic,datetime pExpiration,color pColor)
{
  int ticket=0;
  int err=0;
  int c = 0;
  int NumberOfTries = 100;
  switch (pType)
  {
      case OP_BUYLIMIT:
         for(c = 0 ; c < NumberOfTries ; c++)
         {
            ticket=OrderSend(Symbol(),OP_BUYLIMIT,pLots,pLevel,sp,StopLong(pr,sl),TakeLong(pLevel,tp),pComment,pMagic,pExpiration,pColor);
            err=GetLastError();
            if(err==0)
            { 
               break;
            }
            else
            {
               if(err==4 || err==137 ||err==146 || err==136) //Busy errors
               {
                  Sleep(1000);
                  continue;
               }
               else //normal error
               {
                  break;
               }  
            }
         }   
         break;
      case OP_BUYSTOP:
         for(c = 0 ; c < NumberOfTries ; c++)
         {
            ticket=OrderSend(Symbol(),OP_BUYSTOP,pLots,pLevel,sp,StopLong(pr,sl),TakeLong(pLevel,tp),pComment,pMagic,pExpiration,pColor);
            err=GetLastError();
            if(err==0)
            { 
               break;
            }
            else
            {
               if(err==4 || err==137 ||err==146 || err==136) //Busy errors
               {
                  Sleep(5000);
                  continue;
               }
               else //normal error
               {
                  break;
               }  
            }
         } 
         break;
      case OP_BUY:
         for(c = 0 ; c < NumberOfTries ; c++)
         {  
            RefreshRates();
            ticket=OrderSend(Symbol(),OP_BUY,pLots,Ask,sp,StopLong(Bid,sl),TakeLong(Ask,tp),pComment,pMagic,pExpiration,pColor);
            err=GetLastError();
            if(err==0)
            { 
               break;
            }
            else
            {
               if(err==4 || err==137 ||err==146 || err==136) //Busy errors
               {
                  Sleep(5000);
                  continue;
               }
               else //normal error
               {
                  break;
               }  
            }
         } 
         break;
      case OP_SELLLIMIT:
         for(c = 0 ; c < NumberOfTries ; c++)
         {
            ticket=OrderSend(Symbol(),OP_SELLLIMIT,pLots,pLevel,sp,StopShort(pr,sl),TakeShort(pLevel,tp),pComment,pMagic,pExpiration,pColor);
            err=GetLastError();
            if(err==0)
            { 
               break;
            }
            else
            {
               if(err==4 || err==137 ||err==146 || err==136) //Busy errors
               {
                  Sleep(5000);
                  continue;
               }
               else //normal error
               {
                  break;
               }  
            }
         } 
         break;
      case OP_SELLSTOP:
         for(c = 0 ; c < NumberOfTries ; c++)
         {
            ticket=OrderSend(Symbol(),OP_SELLSTOP,pLots,pLevel,sp,StopShort(pr,sl),TakeShort(pLevel,tp),pComment,pMagic,pExpiration,pColor);
            err=GetLastError();
            if(err==0)
            { 
               break;
            }
            else
            {
               if(err==4 || err==137 ||err==146 || err==136) //Busy errors
               {
                  Sleep(5000);
                  continue;
               }
               else //normal error
               {
                  break;
               }  
            }
         } 
         break;
      case OP_SELL:
         for(c = 0 ; c < NumberOfTries ; c++)
         {
            ticket=OrderSend(Symbol(),OP_SELL,pLots,Bid,sp,StopShort(Ask,sl),TakeShort(Bid,tp),pComment,pMagic,pExpiration,pColor);
            err=GetLastError();
            if(err==0)
            { 
               break;
            }
            else
            {
               if(err==4 || err==137 ||err==146 || err==136) //Busy errors
               {
                  Sleep(5000);
                  continue;
               }
               else //normal error
               {
                  break;
               }  
            }
         } 
         break;
  } 
  
  return(ticket);
}  

double StopLong(double price,int stop)
{
 if(stop==0)
  return(0);
 else
  return(price-(stop*Point));
}

double StopShort(double price,int stop)
{
 if(stop==0)
  return(0);
 else
  return(price+(stop*Point));
}

double TakeLong(double price,int take)
{
 if(take==0)
  return(0);
 else
  return(price+(take*Point));
}

double TakeShort(double price,int take)
{
 if(take==0)
  return(0);
 else
  return(price-(take*Point));
}

bool CloseLongs()
{
 bool Closed;
 int trade;
 for(trade=OrdersTotal()-1;trade>=0;trade--)
 {
  OrderSelect(trade,SELECT_BY_POS,MODE_TRADES);

  if(OrderSymbol()!=Symbol())
   continue;
  if(OrderSymbol()==Symbol() && OrderMagicNumber()== MagicNumber)
  {
   if(OrderType()==OP_BUY)
//    Closed = OrderClose(OrderTicket(),OrderLots(),Bid,slip,White);
    Closed = ClosePendingOrder(OP_BUY);

  }
  Sleep(1000);
  return(Closed);
 }
}

bool CloseShorts()
{
 bool Closed;
 int trade;
 for(trade=OrdersTotal()-1;trade>=0;trade--)
 {
  OrderSelect(trade,SELECT_BY_POS,MODE_TRADES);

  if(OrderSymbol()!=Symbol())
   continue;
  if(OrderSymbol()==Symbol() && OrderMagicNumber()== MagicNumber)
  {
   if(OrderType()==OP_SELL)
//    Closed = OrderClose(OrderTicket(),OrderLots(),Ask,slip,White);
    Closed = ClosePendingOrder(OP_SELL);
  }
  Sleep(1000);
  return(Closed);
 }
}

bool CloseThisSymbolAll()
{
 bool Closed;
 int trade;
 for(trade=OrdersTotal()-1;trade>=0;trade--)
 {
  OrderSelect(trade,SELECT_BY_POS,MODE_TRADES);

  if(OrderSymbol()!=Symbol())
   continue;
  if(OrderSymbol()==Symbol() && OrderMagicNumber()== MagicNumber)
  {
   if(OrderType()==OP_SELL)
//    Closed = OrderClose(OrderTicket(),OrderLots(),Ask,slip,White);
      Closed = ClosePendingOrder(OP_SELL);
   if(OrderType()==OP_BUY)
//    Closed = OrderClose(OrderTicket(),OrderLots(),Bid,slip,White);
      Closed = ClosePendingOrder(OP_BUY);
  }
  Sleep(1000);
  return(Closed);
 }
}

double CalculateProfit()
{

   double Profit=0;
   for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
    OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
    if(OrderSymbol()!=Symbol()||OrderMagicNumber()!=MagicNumber)
     continue;
    if(OrderSymbol()==Symbol() && OrderMagicNumber()==MagicNumber)
     if(OrderType()==OP_BUY || OrderType()==OP_SELL)  
      {
       Profit=Profit+OrderProfit();
      }
   }

  return(Profit);
}

double AccountEquityHigh()
{
 static double AccountEquityHighAmt,PrevEquity;
  if(CountTrades()==0) AccountEquityHighAmt=AccountEquity();
   if(AccountEquityHighAmt < PrevEquity) AccountEquityHighAmt=PrevEquity;
   else AccountEquityHighAmt=AccountEquity();
  PrevEquity = AccountEquity();
 return(AccountEquityHighAmt);
}

double FindLastBuyPrice()
{
 double oldorderopenprice = 0, orderprice;
 int cnt, oldticketnumber = 0, ticketnumber;
 
 for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
 {
  OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
  if(OrderSymbol()!=Symbol()||OrderMagicNumber()!=MagicNumber)
   continue;
  if(OrderSymbol()==Symbol() && OrderMagicNumber()==MagicNumber && OrderType()==OP_BUY)  
  {
     ticketnumber = OrderTicket();
     if(ticketnumber>oldticketnumber)
     {
      orderprice=OrderOpenPrice();
      oldorderopenprice=orderprice;
      oldticketnumber=ticketnumber;
     }
  }
 }
 
  return(orderprice);
}

double FindLastSellPrice()
{
 double oldorderopenprice = 0, orderprice;
 int cnt, oldticketnumber = 0, ticketnumber;
 
 for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
 {
  OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
  if(OrderSymbol()!=Symbol()||OrderMagicNumber()!=MagicNumber)
   continue;
  if(OrderSymbol()==Symbol() && OrderMagicNumber()==MagicNumber && OrderType()==OP_SELL)  
  {
     ticketnumber = OrderTicket();
     if(ticketnumber>oldticketnumber)
     {
      orderprice=OrderOpenPrice();
      oldorderopenprice=orderprice;
      oldticketnumber=ticketnumber;
     }
  }
 }
 
  return(orderprice);
}

bool ClosePendingOrder(int pType)
{
  int err=0;
  int c = 0;
  int trade;
  int NumberOfTries = 100;
  bool tradeclosed;
   
   for(trade=OrdersTotal()-1;trade>=0;trade--)
   {
    OrderSelect(trade,SELECT_BY_POS,MODE_TRADES);
      
    if(OrderSymbol()!=Symbol())
      continue;
    if(OrderSymbol()==Symbol() && OrderMagicNumber()== MagicNumber)
    {
     switch (pType)
     {
      case OP_SELL:
         for(c = 0 ; c < NumberOfTries ; c++)
         {
            RefreshRates();
            tradeclosed = OrderClose(OrderTicket(),OrderLots(),Ask,slip,White);
            err=GetLastError();
            if(err==0)
            { 
               break;
            }
            else
            {
               if(err==4 || err==137 ||err==146 || err==136) //Busy errors
               {
                  Sleep(1000);
                  continue;
               }
               else //normal error
               {
                  break;
               }  
            }
         } //for c   
      break; //OpSell
      
      case OP_BUY:
         for(c = 0 ; c < NumberOfTries ; c++)
         {
            RefreshRates();
            tradeclosed = OrderClose(OrderTicket(),OrderLots(),Bid,slip,White);
            err=GetLastError();
            if(err==0)
            { 
               break;
            }
            else
            {
               if(err==4 || err==137 ||err==146 || err==136) //Busy errors
               {
                  Sleep(1000);
                  continue;
               }
               else //normal error
               {
                  break;
               }  
            }
         } //for c   
      break; //OpBuy
      
     }//switch
    } //if OrderSymbol()=Symbol() 
   } //for
  
  return(tradeclosed);
}  



